import { world, ItemStack } from '@minecraft/server';

world.beforeEvents.worldInitialize.subscribe(eventData => {
    eventData.blockTypeRegistry.registerCustomComponent('v360:slabs', {
        onPlayerInteract(e) {
            const { block, player, face } = e;
            const equipment = player.getComponent('equippable');
            const selectedItem = equipment.getEquipment('Mainhand');
            if (selectedItem?.typeId === block.typeId && !block.permutation.getState('v360:double')) {
                const verticalHalf = block.permutation.getState('minecraft:vertical_half');
                const isBottomUp = verticalHalf === 'bottom' && face === 'Up';
                const isTopDown = verticalHalf === 'top' && face === 'Down';
                if (isBottomUp || isTopDown) {
                    if (player.getGameMode() !== "creative") {
                        if (selectedItem.amount > 1) {
                            selectedItem.amount -= 1;
                            equipment.setEquipment('Mainhand', selectedItem);
                        } else if (selectedItem.amount === 1) {
                            equipment.setEquipment('Mainhand', undefined);
                        }
                    }
                    block.setPermutation(block.permutation.withState('v360:double', true));
                    block.setWaterlogged(false);
                    if (block.hasTag('v360:stone_slab')) {
                        player.playSound('use.stone');
                    }
                    else if (block.hasTag('v360:amphibolite')) {
                        player.playSound('use.netherrack');
                    }
                    else if (block.hasTag('v360:calcite')) {
                        player.playSound('step.calcite');
                    }
                    else if (block.hasTag('v360:dripstone')) {
                        player.playSound('step.dripstone');
                    }
                    else if (block.hasTag('v360:wooden_slab')) {
                        player.playSound('use.wood');
                    }
                }
            }
            if (selectedItem?.typeId === 'minecraft:water_bucket' && !block.permutation.getState('v360:waterlogged') && !block.permutation.getState('v360:double')) {
                player.playSound('bucket.empty_water');
                if (player.getGameMode() !== "creative") {
                    equipment.setEquipment('Mainhand', new ItemStack('minecraft:bucket', 1));
                }
                block.setPermutation(block.permutation.withState('v360:waterlogged', true));
                const verticalHalf = block.permutation.getState('minecraft:vertical_half');
                const slabType = block.typeId.split(':')[1];
                const structureName = (verticalHalf === 'bottom') ? `mystructure:bottom_${slabType}` : `mystructure:top_${slabType}`;
                const { x, y, z } = block;
                world.structureManager.place(structureName, e.dimension, { x, y, z });
            }
        }
    });
});